namespace MapClient
{
    partial class MainWindow
    {
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        private SimpleMapClient simpleMapClient;

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        /// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
        protected override void Dispose(bool disposing)
        {
            simpleMapClient.closeSOAPConnection();
            simpleMapClient.getHelloWindow().Dispose();
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
            
        }

        public void setAvailableLayers( string[] items )
        {
            layersCheckedListBox.Items.AddRange(items);
        }
        
        public void setAllLayers()
        {
            for (int i = 0; i < layersCheckedListBox.Items.Count; i++)
                layersCheckedListBox.SetItemChecked(i, true);

        }
        
        public string[] getSelectedLayers()
        {
            string[] selectedItems = new string[layersCheckedListBox.CheckedItems.Count];
            layersCheckedListBox.CheckedItems.CopyTo(selectedItems, 0);
            return selectedItems;
        }

        public void setAvailableProjections( string[] projections)
        {
            projectionsListBox.Items.AddRange(projections);
            
        }

        public void setSelectedProjection(int number)
        {
            projectionsListBox.SelectedIndex = number;
        }

        public string getSelectedProjection()
        {
            return projectionsListBox.SelectedItem.ToString();
        }

        public double getLatitude()
        {
            return double.Parse(latitudeTextBox.Text);
        }

        public void setLatitude(double latitude)
        {
            latitudeTextBox.Text = latitude.ToString();
        }

        public double getLongitude()
        {
            return double.Parse(longitudeTextBox.Text);
        }

        public void setLongitude(double longitude)
        {
            longitudeTextBox.Text = longitude.ToString();
        }

        public double getRotation()
        {
            return (double) rotationNumericUpDown.Value;
        }

        public void setRotation(double value)
        {
            rotationNumericUpDown.Value = (decimal)value;
        }

        public void setRotationMin(double value)
        {
            rotationNumericUpDown.Minimum = (decimal)value;
        }

        public void setRotationMax(double value)
        {
            rotationNumericUpDown.Maximum = (decimal)value;
        }


        public double getTilt()
        {
            return (double)tiltNumericUpDown.Value;
        }

        public void setTilt(double value)
        {
            tiltNumericUpDown.Value = (decimal)value;
        }

        public void setTiltMin(double value)
        {
            tiltNumericUpDown.Minimum = (decimal)value;
        }

        public void setTiltMax(double value)
        {
            tiltNumericUpDown.Maximum = (decimal)value;
        }

        public string getSearch()
        {
            return SearchCityTextBox.Text;
        }

        public void addAvailableCity(string city)
        {
           foundCitiesListBox.Items.Add(city);
        }

        public void setSelectedCity(int number)
        {
             foundCitiesListBox.SelectedIndex = number;
        }

        public void clearCities()
        {
            foundCitiesListBox.Items.Clear();
        }

        public int getSelectedCity()
        {
            return foundCitiesListBox.SelectedIndex;
        }

        public int lengthOfCityList()
        {
            return foundCitiesListBox.Items.Count;
        
        }

        public void disableCityList()
        {
            foundCitiesListBox.Enabled = false;
        }

        public void enableCityList()
        {
            foundCitiesListBox.Enabled = true;
        }

        public int getDisplayPanelWidth()
        {
            return pictureBox1.Width;
        }

        public int getDisplayPanelHeight()
        {
            return pictureBox1.Height;
        }

        public void setImage(System.Drawing.Image image)
        {
            pictureBox1.Image = image;
        }

        public double getAltitude()
        {
            return (double)altitudeNumericUpDown.Value;
        }

        public void setAltitude(double value)
        {
            altitudeNumericUpDown.Value = (int)value;
        }

        public void setAltitudeMin(double value)
        {
            altitudeNumericUpDown.Minimum = (decimal)value;
        }

        public void setAltitudeMax(double value)
        {
            altitudeNumericUpDown.Maximum = (decimal)value;
        }

        public string getSearchStreet()
        {
            return searchStreetTextBox.Text;
        }


        public void addAvailableStreet(string street)
        {
            foundStreetsListBox.Items.Add(street);
        }

        public int getSelectedStreet()
        {
            return foundStreetsListBox.SelectedIndex;
        }

        public void clearSelectedStreet()
        {
            foundStreetsListBox.Items.Clear();
        }

        public void disableStreetList()                     
        {
            foundStreetsListBox.Enabled = false;

        }

        public void enableStreetList()                         
        {
            foundStreetsListBox.Enabled = true;
        }

        public string getStreetNumber()
        {
            return StreetNumberTextBox.Text;
        }

        public void clearNumberTextBox()
        {
            StreetNumberTextBox.Clear();
        }

        public void addToGrid(string[] text)
        {
            openFileGridView.Rows.Add(text);
        }

        public int getCurrentRowIndex()
        {
            return openFileGridView.CurrentCellAddress.Y;
        }

        public string[] getFromOpenFileDataGrid(int row)
        {
            string[] inGridText = new string[openFileGridView.Columns.Count];
            for (int i = 0; i < openFileGridView.Columns.Count; i++)
            {
                inGridText[i] = openFileGridView.Rows[row].Cells[i].Value.ToString();
            }
            return inGridText;
        }

        public void clearOpenFileDataGrid()
        {
            for (int j = 0; j < openFileGridView.Columns.Count; j++)
            {
                for (int i = 0; i < openFileGridView.Rows.Count; i++)
                {
                    openFileGridView.Rows.RemoveAt(i);
                }
            }
    
        }

        #region Windows Form Designer generated code

        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.showMessagesButton = new System.Windows.Forms.Button();
            this.label1 = new System.Windows.Forms.Label();
            this.latitudeTextBox = new System.Windows.Forms.TextBox();
            this.label2 = new System.Windows.Forms.Label();
            this.longitudeTextBox = new System.Windows.Forms.TextBox();
            this.refreshButton = new System.Windows.Forms.Button();
            this.MoveOrZoomRadioButton = new System.Windows.Forms.RadioButton();
            this.radioButton2 = new System.Windows.Forms.RadioButton();
            this.tabPage3 = new System.Windows.Forms.TabPage();
            this.openFileGridView = new System.Windows.Forms.DataGridView();
            this.Country = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.County = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.District = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.City = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.Zip = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.Street = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.numberOfStreet = new System.Windows.Forms.DataGridViewTextBoxColumn();
            this.openFileButton = new System.Windows.Forms.Button();
            this.tabPage2 = new System.Windows.Forms.TabPage();
            this.clearSelectedItemButton = new System.Windows.Forms.Button();
            this.searchButton = new System.Windows.Forms.Button();
            this.foundStreetsListBox = new System.Windows.Forms.ListBox();
            this.label8 = new System.Windows.Forms.Label();
            this.label9 = new System.Windows.Forms.Label();
            this.SearchCityTextBox = new System.Windows.Forms.TextBox();
            this.label7 = new System.Windows.Forms.Label();
            this.Wyszukiwanie = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.searchStreetTextBox = new System.Windows.Forms.TextBox();
            this.StreetNumberTextBox = new System.Windows.Forms.TextBox();
            this.foundCitiesListBox = new System.Windows.Forms.ListBox();
            this.tabPage1 = new System.Windows.Forms.TabPage();
            this.label11 = new System.Windows.Forms.Label();
            this.label10 = new System.Windows.Forms.Label();
            this.layersCheckedListBox = new System.Windows.Forms.CheckedListBox();
            this.projectionsListBox = new System.Windows.Forms.ListBox();
            this.altitudeNumericUpDown = new System.Windows.Forms.NumericUpDown();
            this.label3 = new System.Windows.Forms.Label();
            this.rotationNumericUpDown = new System.Windows.Forms.NumericUpDown();
            this.label4 = new System.Windows.Forms.Label();
            this.tiltNumericUpDown = new System.Windows.Forms.NumericUpDown();
            this.label5 = new System.Windows.Forms.Label();
            this.tabControl1 = new System.Windows.Forms.TabControl();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.tabPage3.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.openFileGridView)).BeginInit();
            this.tabPage2.SuspendLayout();
            this.tabPage1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.altitudeNumericUpDown)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.rotationNumericUpDown)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.tiltNumericUpDown)).BeginInit();
            this.tabControl1.SuspendLayout();
            this.SuspendLayout();
            // 
            // pictureBox1
            // 
            this.pictureBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.pictureBox1.Cursor = System.Windows.Forms.Cursors.Cross;
            this.pictureBox1.Location = new System.Drawing.Point(12, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(798, 433);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.CenterImage;
            this.pictureBox1.TabIndex = 13;
            this.pictureBox1.TabStop = false;
            this.pictureBox1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.pictureBox1_MouseDown);
            this.pictureBox1.MouseMove += new System.Windows.Forms.MouseEventHandler(this.pictureBox1_MouseMove);
            this.pictureBox1.MouseUp += new System.Windows.Forms.MouseEventHandler(this.pictureBox1_MouseUp);
            // 
            // showMessagesButton
            // 
            this.showMessagesButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.showMessagesButton.Location = new System.Drawing.Point(653, 631);
            this.showMessagesButton.Name = "showMessagesButton";
            this.showMessagesButton.Size = new System.Drawing.Size(145, 25);
            this.showMessagesButton.TabIndex = 0;
            this.showMessagesButton.Text = "Show hello window";
            this.showMessagesButton.UseVisualStyleBackColor = true;
            this.showMessagesButton.Click += new System.EventHandler(this.showMessagesButton_Click);
            // 
            // label1
            // 
            this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(650, 473);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(51, 13);
            this.label1.TabIndex = 3;
            this.label1.Text = "Latitude: ";
            // 
            // latitudeTextBox
            // 
            this.latitudeTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.latitudeTextBox.Location = new System.Drawing.Point(653, 489);
            this.latitudeTextBox.Name = "latitudeTextBox";
            this.latitudeTextBox.Size = new System.Drawing.Size(143, 20);
            this.latitudeTextBox.TabIndex = 3;
            // 
            // label2
            // 
            this.label2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(650, 512);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(57, 13);
            this.label2.TabIndex = 5;
            this.label2.Text = "Longitude:";
            // 
            // longitudeTextBox
            // 
            this.longitudeTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.longitudeTextBox.Location = new System.Drawing.Point(653, 528);
            this.longitudeTextBox.Name = "longitudeTextBox";
            this.longitudeTextBox.Size = new System.Drawing.Size(143, 20);
            this.longitudeTextBox.TabIndex = 4;
            // 
            // refreshButton
            // 
            this.refreshButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.refreshButton.Location = new System.Drawing.Point(653, 554);
            this.refreshButton.Name = "refreshButton";
            this.refreshButton.Size = new System.Drawing.Size(143, 25);
            this.refreshButton.TabIndex = 8;
            this.refreshButton.Text = "Map refresh";
            this.refreshButton.UseVisualStyleBackColor = true;
            this.refreshButton.Click += new System.EventHandler(this.refreshButton_Click);
            // 
            // MoveOrZoomRadioButton
            // 
            this.MoveOrZoomRadioButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.MoveOrZoomRadioButton.AutoSize = true;
            this.MoveOrZoomRadioButton.Location = new System.Drawing.Point(653, 585);
            this.MoveOrZoomRadioButton.Name = "MoveOrZoomRadioButton";
            this.MoveOrZoomRadioButton.Size = new System.Drawing.Size(75, 17);
            this.MoveOrZoomRadioButton.TabIndex = 34;
            this.MoveOrZoomRadioButton.TabStop = true;
            this.MoveOrZoomRadioButton.Text = "Map move";
            this.MoveOrZoomRadioButton.UseVisualStyleBackColor = true;
            this.MoveOrZoomRadioButton.CheckedChanged += new System.EventHandler(this.moveCheckedChanged);
            // 
            // radioButton2
            // 
            this.radioButton2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.radioButton2.AutoSize = true;
            this.radioButton2.Checked = true;
            this.radioButton2.Location = new System.Drawing.Point(653, 608);
            this.radioButton2.Name = "radioButton2";
            this.radioButton2.Size = new System.Drawing.Size(52, 17);
            this.radioButton2.TabIndex = 35;
            this.radioButton2.TabStop = true;
            this.radioButton2.Text = "Zoom";
            this.radioButton2.UseVisualStyleBackColor = true;
            this.radioButton2.CheckedChanged += new System.EventHandler(this.zoomCheckedChanged);
            // 
            // tabPage3
            // 
            this.tabPage3.Controls.Add(this.openFileGridView);
            this.tabPage3.Controls.Add(this.openFileButton);
            this.tabPage3.Location = new System.Drawing.Point(4, 22);
            this.tabPage3.Name = "tabPage3";
            this.tabPage3.Padding = new System.Windows.Forms.Padding(3);
            this.tabPage3.Size = new System.Drawing.Size(627, 208);
            this.tabPage3.TabIndex = 2;
            this.tabPage3.Text = "Localize";
            this.tabPage3.UseVisualStyleBackColor = true;
            // 
            // openFileGridView
            // 
            this.openFileGridView.AllowUserToAddRows = false;
            this.openFileGridView.AllowUserToDeleteRows = false;
            this.openFileGridView.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.openFileGridView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.openFileGridView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
            this.openFileGridView.Columns.AddRange(new System.Windows.Forms.DataGridViewColumn[] {
            this.Country,
            this.County,
            this.District,
            this.City,
            this.Zip,
            this.Street,
            this.numberOfStreet});
            this.openFileGridView.Location = new System.Drawing.Point(0, 7);
            this.openFileGridView.MultiSelect = false;
            this.openFileGridView.Name = "openFileGridView";
            this.openFileGridView.ReadOnly = true;
            this.openFileGridView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
            this.openFileGridView.Size = new System.Drawing.Size(627, 154);
            this.openFileGridView.TabIndex = 1;
            this.openFileGridView.Click += new System.EventHandler(this.openFiledataGrid_Click);
            // 
            // Country
            // 
            this.Country.HeaderText = "Country";
            this.Country.Name = "Country";
            this.Country.ReadOnly = true;
            // 
            // County
            // 
            this.County.HeaderText = "County";
            this.County.Name = "County";
            this.County.ReadOnly = true;
            // 
            // District
            // 
            this.District.HeaderText = "District";
            this.District.Name = "District";
            this.District.ReadOnly = true;
            // 
            // City
            // 
            this.City.HeaderText = "City";
            this.City.Name = "City";
            this.City.ReadOnly = true;
            // 
            // Zip
            // 
            this.Zip.HeaderText = "Zip code";
            this.Zip.Name = "Zip";
            this.Zip.ReadOnly = true;
            // 
            // Street
            // 
            this.Street.HeaderText = "Street";
            this.Street.Name = "Street";
            this.Street.ReadOnly = true;
            // 
            // numberOfStreet
            // 
            this.numberOfStreet.HeaderText = "Street number";
            this.numberOfStreet.Name = "numberOfStreet";
            this.numberOfStreet.ReadOnly = true;
            // 
            // openFileButton
            // 
            this.openFileButton.Location = new System.Drawing.Point(3, 177);
            this.openFileButton.Name = "openFileButton";
            this.openFileButton.Size = new System.Drawing.Size(82, 25);
            this.openFileButton.TabIndex = 0;
            this.openFileButton.Text = "Open file";
            this.openFileButton.UseVisualStyleBackColor = true;
            this.openFileButton.Click += new System.EventHandler(this.openFileButton_Click);
            // 
            // tabPage2
            // 
            this.tabPage2.Controls.Add(this.clearSelectedItemButton);
            this.tabPage2.Controls.Add(this.searchButton);
            this.tabPage2.Controls.Add(this.foundStreetsListBox);
            this.tabPage2.Controls.Add(this.label8);
            this.tabPage2.Controls.Add(this.label9);
            this.tabPage2.Controls.Add(this.SearchCityTextBox);
            this.tabPage2.Controls.Add(this.label7);
            this.tabPage2.Controls.Add(this.Wyszukiwanie);
            this.tabPage2.Controls.Add(this.label6);
            this.tabPage2.Controls.Add(this.searchStreetTextBox);
            this.tabPage2.Controls.Add(this.StreetNumberTextBox);
            this.tabPage2.Controls.Add(this.foundCitiesListBox);
            this.tabPage2.Location = new System.Drawing.Point(4, 22);
            this.tabPage2.Name = "tabPage2";
            this.tabPage2.Padding = new System.Windows.Forms.Padding(3);
            this.tabPage2.Size = new System.Drawing.Size(627, 208);
            this.tabPage2.TabIndex = 1;
            this.tabPage2.Text = "Search";
            this.tabPage2.UseVisualStyleBackColor = true;
            // 
            // clearSelectedItemButton
            // 
            this.clearSelectedItemButton.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.clearSelectedItemButton.Location = new System.Drawing.Point(9, 154);
            this.clearSelectedItemButton.Name = "clearSelectedItemButton";
            this.clearSelectedItemButton.Size = new System.Drawing.Size(105, 25);
            this.clearSelectedItemButton.TabIndex = 29;
            this.clearSelectedItemButton.Text = "Clear map";
            this.clearSelectedItemButton.UseVisualStyleBackColor = true;
            this.clearSelectedItemButton.Click += new System.EventHandler(this.clearSelectedItemButton_Click);
            // 
            // searchButton
            // 
            this.searchButton.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.searchButton.Location = new System.Drawing.Point(9, 123);
            this.searchButton.Name = "searchButton";
            this.searchButton.Size = new System.Drawing.Size(105, 25);
            this.searchButton.TabIndex = 24;
            this.searchButton.Text = "Search";
            this.searchButton.UseVisualStyleBackColor = true;
            this.searchButton.Click += new System.EventHandler(this.searchButton_Click);
            // 
            // foundStreetsListBox
            // 
            this.foundStreetsListBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.foundStreetsListBox.FormattingEnabled = true;
            this.foundStreetsListBox.Location = new System.Drawing.Point(405, 24);
            this.foundStreetsListBox.Name = "foundStreetsListBox";
            this.foundStreetsListBox.Size = new System.Drawing.Size(214, 134);
            this.foundStreetsListBox.TabIndex = 26;
            this.foundStreetsListBox.Click += new System.EventHandler(this.schowSerchedStreet_Click);
            // 
            // label8
            // 
            this.label8.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label8.AutoSize = true;
            this.label8.Location = new System.Drawing.Point(402, 8);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(74, 13);
            this.label8.TabIndex = 27;
            this.label8.Text = "Found streets:";
            // 
            // label9
            // 
            this.label9.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label9.AutoSize = true;
            this.label9.Location = new System.Drawing.Point(6, 83);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(76, 13);
            this.label9.TabIndex = 27;
            this.label9.Text = "Street number:";
            // 
            // SearchCityTextBox
            // 
            this.SearchCityTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.SearchCityTextBox.Location = new System.Drawing.Point(53, 24);
            this.SearchCityTextBox.Name = "SearchCityTextBox";
            this.SearchCityTextBox.Size = new System.Drawing.Size(109, 20);
            this.SearchCityTextBox.TabIndex = 21;
            // 
            // label7
            // 
            this.label7.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label7.AutoSize = true;
            this.label7.Location = new System.Drawing.Point(182, 8);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(67, 13);
            this.label7.TabIndex = 28;
            this.label7.Text = "Found cities:";
            // 
            // Wyszukiwanie
            // 
            this.Wyszukiwanie.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.Wyszukiwanie.AutoSize = true;
            this.Wyszukiwanie.Location = new System.Drawing.Point(6, 31);
            this.Wyszukiwanie.Name = "Wyszukiwanie";
            this.Wyszukiwanie.Size = new System.Drawing.Size(27, 13);
            this.Wyszukiwanie.TabIndex = 14;
            this.Wyszukiwanie.Text = "City:";
            // 
            // label6
            // 
            this.label6.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(6, 58);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(38, 13);
            this.label6.TabIndex = 24;
            this.label6.Text = "Street:";
            // 
            // searchStreetTextBox
            // 
            this.searchStreetTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.searchStreetTextBox.Location = new System.Drawing.Point(53, 50);
            this.searchStreetTextBox.Name = "searchStreetTextBox";
            this.searchStreetTextBox.Size = new System.Drawing.Size(109, 20);
            this.searchStreetTextBox.TabIndex = 22;
            // 
            // StreetNumberTextBox
            // 
            this.StreetNumberTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.StreetNumberTextBox.Location = new System.Drawing.Point(125, 76);
            this.StreetNumberTextBox.Name = "StreetNumberTextBox";
            this.StreetNumberTextBox.Size = new System.Drawing.Size(37, 20);
            this.StreetNumberTextBox.TabIndex = 23;
            // 
            // foundCitiesListBox
            // 
            this.foundCitiesListBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.foundCitiesListBox.FormattingEnabled = true;
            this.foundCitiesListBox.HorizontalScrollbar = true;
            this.foundCitiesListBox.Location = new System.Drawing.Point(185, 24);
            this.foundCitiesListBox.MaximumSize = new System.Drawing.Size(300, 300);
            this.foundCitiesListBox.Name = "foundCitiesListBox";
            this.foundCitiesListBox.Size = new System.Drawing.Size(214, 134);
            this.foundCitiesListBox.TabIndex = 25;
            this.foundCitiesListBox.Click += new System.EventHandler(this.schowSearched_Click);
            // 
            // tabPage1
            // 
            this.tabPage1.Controls.Add(this.label11);
            this.tabPage1.Controls.Add(this.label10);
            this.tabPage1.Controls.Add(this.layersCheckedListBox);
            this.tabPage1.Controls.Add(this.projectionsListBox);
            this.tabPage1.Controls.Add(this.altitudeNumericUpDown);
            this.tabPage1.Controls.Add(this.label3);
            this.tabPage1.Controls.Add(this.rotationNumericUpDown);
            this.tabPage1.Controls.Add(this.label4);
            this.tabPage1.Controls.Add(this.tiltNumericUpDown);
            this.tabPage1.Controls.Add(this.label5);
            this.tabPage1.Location = new System.Drawing.Point(4, 22);
            this.tabPage1.Name = "tabPage1";
            this.tabPage1.Padding = new System.Windows.Forms.Padding(3);
            this.tabPage1.Size = new System.Drawing.Size(627, 208);
            this.tabPage1.TabIndex = 0;
            this.tabPage1.Text = "Map properties";
            this.tabPage1.UseVisualStyleBackColor = true;
            // 
            // label11
            // 
            this.label11.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label11.AutoSize = true;
            this.label11.Location = new System.Drawing.Point(171, 3);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(88, 13);
            this.label11.TabIndex = 13;
            this.label11.Text = "Map projections: ";
            // 
            // label10
            // 
            this.label10.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label10.AutoSize = true;
            this.label10.Location = new System.Drawing.Point(3, 1);
            this.label10.Name = "label10";
            this.label10.Size = new System.Drawing.Size(61, 13);
            this.label10.TabIndex = 12;
            this.label10.Text = "Map layers:";
            // 
            // layersCheckedListBox
            // 
            this.layersCheckedListBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.layersCheckedListBox.CheckOnClick = true;
            this.layersCheckedListBox.FormattingEnabled = true;
            this.layersCheckedListBox.ImeMode = System.Windows.Forms.ImeMode.NoControl;
            this.layersCheckedListBox.Location = new System.Drawing.Point(6, 17);
            this.layersCheckedListBox.Name = "layersCheckedListBox";
            this.layersCheckedListBox.Size = new System.Drawing.Size(144, 94);
            this.layersCheckedListBox.TabIndex = 1;
            // 
            // projectionsListBox
            // 
            this.projectionsListBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.projectionsListBox.FormattingEnabled = true;
            this.projectionsListBox.Location = new System.Drawing.Point(174, 19);
            this.projectionsListBox.Name = "projectionsListBox";
            this.projectionsListBox.Size = new System.Drawing.Size(221, 147);
            this.projectionsListBox.TabIndex = 2;
            // 
            // altitudeNumericUpDown
            // 
            this.altitudeNumericUpDown.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.altitudeNumericUpDown.Increment = new decimal(new int[] {
            1000,
            0,
            0,
            0});
            this.altitudeNumericUpDown.Location = new System.Drawing.Point(422, 19);
            this.altitudeNumericUpDown.Maximum = new decimal(new int[] {
            1300000,
            0,
            0,
            0});
            this.altitudeNumericUpDown.Minimum = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.altitudeNumericUpDown.Name = "altitudeNumericUpDown";
            this.altitudeNumericUpDown.Size = new System.Drawing.Size(145, 20);
            this.altitudeNumericUpDown.TabIndex = 5;
            this.altitudeNumericUpDown.Value = new decimal(new int[] {
            1300000,
            0,
            0,
            0});
            // 
            // label3
            // 
            this.label3.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(419, 3);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(71, 13);
            this.label3.TabIndex = 7;
            this.label3.Text = "Map altitude: ";
            // 
            // rotationNumericUpDown
            // 
            this.rotationNumericUpDown.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.rotationNumericUpDown.Location = new System.Drawing.Point(422, 61);
            this.rotationNumericUpDown.Name = "rotationNumericUpDown";
            this.rotationNumericUpDown.Size = new System.Drawing.Size(145, 20);
            this.rotationNumericUpDown.TabIndex = 6;
            // 
            // label4
            // 
            this.label4.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(419, 44);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(72, 13);
            this.label4.TabIndex = 10;
            this.label4.Text = "Map rotation: ";
            // 
            // tiltNumericUpDown
            // 
            this.tiltNumericUpDown.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.tiltNumericUpDown.Location = new System.Drawing.Point(422, 100);
            this.tiltNumericUpDown.Name = "tiltNumericUpDown";
            this.tiltNumericUpDown.Size = new System.Drawing.Size(145, 20);
            this.tiltNumericUpDown.TabIndex = 7;
            // 
            // label5
            // 
            this.label5.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(419, 84);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(44, 13);
            this.label5.TabIndex = 11;
            this.label5.Text = "Map tilt:";
            // 
            // tabControl1
            // 
            this.tabControl1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.tabControl1.Controls.Add(this.tabPage1);
            this.tabControl1.Controls.Add(this.tabPage2);
            this.tabControl1.Controls.Add(this.tabPage3);
            this.tabControl1.Location = new System.Drawing.Point(12, 451);
            this.tabControl1.Name = "tabControl1";
            this.tabControl1.SelectedIndex = 0;
            this.tabControl1.Size = new System.Drawing.Size(635, 234);
            this.tabControl1.TabIndex = 36;
            // 
            // MainWindow
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.ClientSize = new System.Drawing.Size(822, 697);
            this.Controls.Add(this.tabControl1);
            this.Controls.Add(this.radioButton2);
            this.Controls.Add(this.MoveOrZoomRadioButton);
            this.Controls.Add(this.refreshButton);
            this.Controls.Add(this.pictureBox1);
            this.Controls.Add(this.longitudeTextBox);
            this.Controls.Add(this.label2);
            this.Controls.Add(this.latitudeTextBox);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.showMessagesButton);
            this.MinimizeBox = false;
            this.Name = "MainWindow";
            this.Text = "Simple map client";
            this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
            this.FormClosed += new System.Windows.Forms.FormClosedEventHandler(this.MainWindow_FormClosed);
            this.Resize += new System.EventHandler(this.refreshButton_Click);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.tabPage3.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.openFileGridView)).EndInit();
            this.tabPage2.ResumeLayout(false);
            this.tabPage2.PerformLayout();
            this.tabPage1.ResumeLayout(false);
            this.tabPage1.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.altitudeNumericUpDown)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.rotationNumericUpDown)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.tiltNumericUpDown)).EndInit();
            this.tabControl1.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        #endregion

        private System.Windows.Forms.PictureBox pictureBox1;
        private System.Windows.Forms.Button showMessagesButton;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.TextBox latitudeTextBox;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.TextBox longitudeTextBox;
        private System.Windows.Forms.Button refreshButton;
        private System.Windows.Forms.RadioButton MoveOrZoomRadioButton;
        private System.Windows.Forms.RadioButton radioButton2;
        private System.Windows.Forms.TabPage tabPage3;
        private System.Windows.Forms.DataGridView openFileGridView;
        private System.Windows.Forms.DataGridViewTextBoxColumn Country;
        private System.Windows.Forms.DataGridViewTextBoxColumn County;
        private System.Windows.Forms.DataGridViewTextBoxColumn District;
        private System.Windows.Forms.DataGridViewTextBoxColumn City;
        private System.Windows.Forms.DataGridViewTextBoxColumn Zip;
        private System.Windows.Forms.DataGridViewTextBoxColumn Street;
        private System.Windows.Forms.DataGridViewTextBoxColumn numberOfStreet;
        private System.Windows.Forms.Button openFileButton;
        private System.Windows.Forms.TabPage tabPage2;
        private System.Windows.Forms.Button clearSelectedItemButton;
        private System.Windows.Forms.Button searchButton;
        private System.Windows.Forms.ListBox foundStreetsListBox;
        private System.Windows.Forms.Label label8;
        private System.Windows.Forms.Label label9;
        private System.Windows.Forms.TextBox SearchCityTextBox;
        private System.Windows.Forms.Label label7;
        private System.Windows.Forms.Label Wyszukiwanie;
        private System.Windows.Forms.Label label6;
        private System.Windows.Forms.TextBox searchStreetTextBox;
        private System.Windows.Forms.TextBox StreetNumberTextBox;
        private System.Windows.Forms.ListBox foundCitiesListBox;
        private System.Windows.Forms.TabPage tabPage1;
        private System.Windows.Forms.CheckedListBox layersCheckedListBox;
        private System.Windows.Forms.ListBox projectionsListBox;
        private System.Windows.Forms.NumericUpDown altitudeNumericUpDown;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.NumericUpDown rotationNumericUpDown;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.NumericUpDown tiltNumericUpDown;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.TabControl tabControl1;
        private System.Windows.Forms.Label label11;
        private System.Windows.Forms.Label label10;

    }
}

