using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace MapClient
{
    // this class is responsible for handling auxilary application window
    public partial class HelloWindow : Form
    {
        // handle to main application class
        private SimpleMapClient simpleMapClient;

        // the only one constructor
        public HelloWindow(SimpleMapClient _simpleMapClient)
        {
            simpleMapClient = _simpleMapClient;
            InitializeComponent();
        }

        // this method hides the window, but NOT close it
        private void closeButton_Click(object sender, EventArgs e)
        {
            this.Hide(); 
        }

        // this method shows another message to user
        public void addMessage(string message)
        {
            textBox.AppendText(message);
        }

        // this method shows another message to user
        public void addMessageLine(string message)
        {
            textBox.AppendText(message + Environment.NewLine);
        }

        public void setServerName(string serverName)
        {
            serverNameTextBox.Text = serverName;
        }

        public string getServerName()
        {
            return serverNameTextBox.Text;
        }

        public void setServerPort(int portNumber)
        {
            portTextBox.Text = portNumber.ToString();
        }

        public string getServerPort()
        {
            return portTextBox.Text;
        }
        
        public void setUserName(string userName)
        {
            userNameTextBox.Text = userName;

        }

        public string getUserName()
        {
            return userNameTextBox.Text;
        }

        public string getUserPassword()
        {
            return userPasswordTextBox.Text;
        }

        public void enableConnect()
        {
            connectButton.Enabled = true;
        }

        // this method tries to establish connection to server and shows main window if succeeded 
        private void connectButton_Click(object sender, EventArgs e)
        {
            connectButton.Enabled = false;
            if (simpleMapClient.connectToServer())
            {
                hideButton.Enabled = true;
                new Thread(new ParameterizedThreadStart(SimpleMapClient.mainWindowThreadMethod)).Start(simpleMapClient);
            }
            else
            {
                connectButton.Enabled = true;
                hideButton.Enabled = false;
            }
        }

        // this is method is invoked during window closing
        private void HelloWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!connectButton.Enabled)
           {
                this.Hide();
                e.Cancel = true;
            }
        }

    }
}