using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace MapClient
{
    // this class contains all map parameters that are necesesery to download map
    public class MapParameters
    {
        // fields initialized with default values
        // these values are shoen at program beginning
        private string typeOfProjection = getDefaultTypeOfProjection();
        private string[] visibleLayers = getDefaultVisibleLayers();
        private double altitude = getDefaultAltitude();
        private double rotation = getDefaultRotation();
        private double tilt = getDefaultTilt();
        private int dpi = 96;

        public string TypeOfProjection
        {
            get
            {
                return this.typeOfProjection;
            }
            set
            {
                this.typeOfProjection = value;
            }
        }
        
        static public string getDefaultTypeOfProjection()
        {
            return "Mercator";
        }
        
        public string[] VisibleLayers
        {
            get
            {
                return this.visibleLayers;
            }
            set
            {
                this.visibleLayers = value;
            }
        }
        
        // default visible layers: all layers are selected
        static public string[] getDefaultVisibleLayers()
        {
            return new string[] 
            {   
                "AdministrativeLayers",
                "TopographicLayers",
                "RoadNetworkLayers",
                "PointsLayers",
                "NamesLayers",
                "ElevationLayers"  
            };
        }
        
        public double Altitude
        {  
            get
            {
                return this.altitude;
            }
            set
            {
                this.altitude = value;
            }
        }
        
        static public double getDefaultAltitude()
        {
            return 1300000.0;
        }
        
        public double Rotation
        {
            get
            {
                return this.rotation;
            }
            set
            {
                this.rotation = value;
            }
        }
        
        static public double getDefaultRotation()
        {
            return 0.0;
        }
        
        public double Tilt
        {
            get
            {
                return this.tilt;
            }
            set
            {
                this.tilt = value;
            }
        }
        
        static public double getDefaultTilt()
        {
            return 0.0;
        }
        
        // it is not adviced to change DPI values; default value is recommended
        public int DPI
        {
            get
            {
                return this.dpi;
            }
        }
    }
}
